function ic_i = check_ic(i)

% Evaluates i's incentives at the ext pts of Mi. 

%-------
% setup
%-------

% global

global beta plr Pr_data x_data n NA NY NW jstate

% local

ERRTOL = 1.0e-7;

%-------------
% computation
%-------------

% memory allocation

ic_i(NW(i)) = struct;
 
% check ic's

for wi = 1:NW(i)
  
  ic_i(wi).dd = zeros(NA(i),size(plr(i).M(wi).ext,1)); % default =0
  
  if (plr(i).M(wi).emp==0) % check only if belief set is non-empty
    
    for ai=1:NA(i); for j=1:size(plr(i).M(wi).ext,1)
        
        cnt_payoff = 0.0; % continuation payoff w/o deviation
        dev_payoff = 0.0; % deviation payoff
        
        for wni=1:NW(n(i))
        
          cnt_payoff = cnt_payoff + plr(i).M(wi).ext(j,wni)*plr(i).v(wi,wni);
          dev_payoff = dev_payoff + plr(i).M(wi).ext(j,wni)*plr(i).v_dev(wi,wni,ai);
          
        end
        
        if (cnt_payoff + ERRTOL < dev_payoff) % ic violated
          ic_i(wi).dd(ai,j) = 1;
        end
        
    end; end
  
  end

end




    